<?php 
error_reporting(E_ALL ^ E_NOTICE); // hide all basic notices from PHP

//If the form is submitted
if(isset($_POST['submitted'])) {
	
	// require a name from user
	if(trim($_POST['contactName']) === '') {
		$nameError =  'Forgot your name!'; 
		$hasError = true;
	} else {
		$name = trim($_POST['contactName']);
	}
	
	// need valid email
	if(trim($_POST['email']) === '')  {
		$emailError = 'Forgot to enter in your e-mail address.';
		$hasError = true;
	} else if (!preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim($_POST['email']))) {
		$emailError = 'You entered an invalid email address.';
		$hasError = true;
	} else {
		$email = trim($_POST['email']);
	}
		
	// we need at least some content
	if(trim($_POST['comments']) === '') {
		$commentError = 'You forgot to enter a message!';
		$hasError = true;
	} else {
		if(function_exists('stripslashes')) {
			$comments = stripslashes(trim($_POST['comments']));
		} else {
			$comments = trim($_POST['comments']);
		}
	}
		
	// upon no failure errors let's email now!
	if(!isset($hasError)) {
		
		$emailTo = 'youremail@address.com';
		$subject = 'Submitted message from '.$name;
		$sendCopy = trim($_POST['sendCopy']);
		$body = "Name: $name \n\nEmail: $email \n\nComments: $comments";
		$headers = 'From: ' .' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;

		mail($emailTo, $subject, $body, $headers);
        
        // set our boolean completion value to TRUE
		$emailSent = true;
	}
}
?>
<!DOCTYPE html>
<!--[if lt IE 7]> <html lang="en" class="no-js ie6"> <![endif]-->
<!--[if IE 7]>    <html lang="en" class="no-js ie7"> <![endif]-->
<!--[if IE 8]>    <html lang="en" class="no-js ie8"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class='no-js' lang='en'>
	<!--<![endif]-->
	<head>
		<meta charset='utf-8' />
		<meta content='IE=edge,chrome=1' http-equiv='X-UA-Compatible' />
		<title>Appena - Coming Soon / Under Construction Page</title>
		<meta name="description" content="">
		<meta name="author" content="">	
		
		<!-- Favicons -->
		<link rel="shortcut icon" href="images/favicon.ico">
		<link rel="apple-touch-icon" href="images/apple-touch-icon.png">
		<link rel="apple-touch-icon" sizes="72x72" href="images/apple-touch-icon-72x72.png">
		<link rel="apple-touch-icon" sizes="114x114" href="images/apple-touch-icon-114x114.png">
		
		<link rel="stylesheet" href="css/maximage.css" type="text/css" media="screen" charset="utf-8" />
		<link rel="stylesheet" href="css/styles.css" type="text/css" media="screen" charset="utf-8" />
		
		<!--[if lt IE 9]>
			<link rel="stylesheet" href="css/font-awesome-ie7.min.css" type="text/css" media="screen" charset="utf-8">
			<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
		<![endif]-->
		
		<!--[if IE 6]>
			<style type="text/css" media="screen">
				.gradient {display:none;}
			</style>
		<![endif]-->

	</head>
	<body> 

		<div id="loading"></div>

		<!-- Countdown -->
		<div id="asNeeded" class="countdown"></div>

		<!-- Switch to full screen-->
		<a class="full-screen-btn" href="#" onclick="$(document).toggleFullScreen()"><i class="icon-resize-full"></i></a>

		<!-- Site Logo -->
		<div id="logo">Appena</div>

		<!-- Main Navigation -->
		<nav id="navigation" class="main-nav">
			<ul id="nav">
				<li><a href="#home" class="active">Home</a></li>
				<li><a href="#about">About</a></li>
				<li><a href="#services">Services</a></li>
				<li><a href="#contact">Contact</a></li>
			</ul>
		</nav>

		<!-- Slider Controls -->
		<a href="" id="arrow_left"><i class="icon-chevron-sign-left icon-3x"></i></a>
		<a href="" id="arrow_right"><i class="icon-chevron-sign-right icon-3x"></i></a>

		<!-- Social Links -->
		<nav id="social" class="social-nav">
			<ul>
				<li><a href="#"><i class="icon-facebook-sign icon-large"></i></a></li>
				<li><a href="#"><i class="icon-twitter icon-large"></i></a></li>
				<li><a href="#"><i class="icon-google-plus icon-large"></i></a></li>
				<li><a href="#"><i class="icon-pinterest icon-large"></i></a></li>
				<li><a href="#"><i class="icon-linkedin-sign icon-large"></i></a></li>
				<li><a href="#"><i class="icon-github icon-large"></i></a></li>
			</ul>
		</nav>

		<div id="content" class="content-container">

			<!-- Home Page -->
			<section class="content show" id="home">
				<h1>Welcome</h1>
				<h2>Our new site is coming soon!</h2>

				<div class="column">
					<h3><i class="icon-desktop"></i> All New Design</h3>
					Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu massa sed orci interdum lobortis. Vivamus rutrum. Sed orci interdum lobortis
				</div>
				<div class="column">
					<h3><i class="icon-rocket"></i> New Features</h3>
					Cras vulputate arcu sit amet sem venenatis dictum. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu massa sed orci interdum lobortis. Vivamus rutrum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. 
				</div>
				<div class="column">
					<h3><i class="icon-heart"></i> All Your Favorites</h3>
					Vivamus rutrum. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Suspendisse eu massa sed orci interdum lobortis.
				</div>

			</section>

			<!-- About Page -->
			<section class="content hide" id="about">
				<h1>About</h1>
				<h2>Here's a little about what we're up to.</h2>

				<div id="accordion">
				  <h3><i class="icon-bullhorn"></i> New Services and Offerings</h3>
				  <div>
				    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum.Mauris mauris ante, blandit et, ultrices a, suscipit eget. Integer ut neque. Vivamus nisi metus, molestie vel, gravida in,condimentum sit amet, nunc. Nam a nibh. Donec suscipit eros.Nam mi. Proin viverra leo ut odio.</p>
				  </div>
				  <h3><i class="icon-user"></i> Brand New to Our Staff</h3>
				  <div>
				   <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum.Mauris mauris ante, blandit et, ultrices a, suscipit eget. Integer ut neque. Vivamus nisi metus, molestie vel, gravida in,condimentum sit amet, nunc. Nam a nibh. Donec suscipit eros.Nam mi. Proin viverra leo ut odio.</p>
				  </div>
				  <h3><i class="icon-briefcase"></i> Awesome Clients</h3>
				  <div>
				    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum.Mauris mauris ante, blandit et, ultrices a, suscipit eget. Integer ut neque. Vivamus nisi metus, molestie vel, gravida in,condimentum sit amet, nunc. Nam a nibh. Donec suscipit eros.Nam mi. Proin viverra leo ut odio.</p>
				  </div>
				</div>
			</section>

			<!-- Services Page -->
			<section class="content hide" id="services">
				<h1>Services</h1>
				<h2>This is what we do.</h2>
				<div class="column">
					<div class="round-icon"><i class="icon-html5 icon-4x"></i></div>
					<h3>Development and Design</h3>
					Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae.
				</div>
				<div class="column">
					<div class="round-icon"><i class="icon-mobile-phone icon-4x"></i></div>
					<h3>Mobile Interface</h3>
					Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae.
				</div>
				<div class="column">
					<div class="round-icon"><i class="icon-cogs icon-4x"></i></div>
					<h3>Creative Strategy</h3>
					Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras vulputate arcu sit amet sem venenatis dictum. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices.
				</div>
			</section>

			<!-- Contact Page -->
			<section class="content hide" id="contact">
				<h1>Contact</h1>
				<h2>Get in touch.</h2>

				<!-- Contact Form -->
				<div class="contact-form">
				<?php if(isset($emailSent) && $emailSent == true) { ?>
		            <div class="alert success">
							<i class="icon-ok-sign icon-large"></i> Email Sent - We'll get back to you soon!
						</div>
		        <?php } else { ?>

				<?php if(isset($hasError) || isset($captchaError) ) { ?>
		            <div class="alert error">
							<i class="icon-exclamation-sign icon-large"></i> Error - Something went wrong.
						</div>
		        <?php } ?>
		 
				<form id="contact-us" action="index.php" method="post">
					<ul>
			            <li>
			            	<label>Name</label>
			            	<input type="text" name="contactName" id="contactName" value="<?php if(isset($_POST['contactName'])) echo $_POST['contactName'];?>" class="txt requiredField" placeholder="Name:" />
							<?php if($nameError != '') { ?>
								<span class="form-error"><?php echo $nameError;?></span> 
							<?php } ?>
			            </li>
			            <li>
			            	<label>Email</label>
			            	<input type="text" name="email" id="email" value="<?php if(isset($_POST['email']))  echo $_POST['email'];?>" class="txt requiredField email" placeholder="Email:" />
							<?php if($emailError != '') { ?>
								<span class="form-error"><?php echo $emailError;?></span>
							<?php } ?>
			            <li>
			            	<label>Message</label>
			            	<textarea name="comments" id="commentsText" class="txtarea requiredField" placeholder="Message:"><?php if(isset($_POST['comments'])) { if(function_exists('stripslashes')) { echo stripslashes($_POST['comments']); } else { echo $_POST['comments']; } } ?></textarea>
							<?php if($commentError != '') { ?>
								<span class="form-error"><?php echo $commentError;?></span> 
							<?php } ?>
			            </li>
			            <li>
			            	<input type="submit" value="Send Message" name="submit" id="submit" class="submit">
			            	<input type="hidden" name="submitted" id="submitted" value="true" />
			            </li>
			        </ul>
				</form>
				<?php } ?>
				</div><!--end the contact form-->

					<p>Email: <a href="#">info@avenir.com</a><br />
						Phone: 123.456.7890<br /></p>
			</section>

		</div><!--close content container-->
		
		<!-- Background Slides -->
		<div id="maximage">
			<div>
				<img src="images/backgrounds/bg-img-1.jpg" alt="" />
				<img class="gradient" src="images/backgrounds/gradient.png" alt="" />
			</div>
			<div>
				<img src="images/backgrounds/bg-img-2.jpg" alt="" />
				<img class="gradient" src="images/backgrounds/gradient.png" alt="" />
			</div>
			<div>
				<img src="images/backgrounds/bg-img-3.jpg" alt="" />
				<img class="gradient" src="images/backgrounds/gradient.png" alt="" />
			</div>
			<div>
				<img src="images/backgrounds/bg-img-4.jpg" alt="" />
				<img class="gradient" src="images/backgrounds/gradient.png" alt="" />
			</div>
			<div>
				<img src="images/backgrounds/bg-img-5.jpg" alt="" />
				<img class="gradient" src="images/backgrounds/gradient.png" alt="" />
			</div>
			<div>
				<img src="images/backgrounds/bg-img-6.jpg" alt="" />
				<img class="gradient" src="images/backgrounds/gradient.png" alt="" />
			</div>
		</div>

		<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.js"></script>
		<script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js"></script>
		<script src="js/modernizr.js" type="text/javascript"></script>
		<script src="js/jquery.easing.min.js" type="text/javascript"></script>
		<script src="js/jquery.cycle.all.js" type="text/javascript"></script>
		<script src="js/jquery.maximage.js" type="text/javascript"></script>
		<script src="js/jquery.fullscreen.js" type="text/javascript"></script>
		<script src="js/jquery.ba-hashchange.js" type="text/javascript"></script>
		<script src="js/jquery.countdown.js" type="text/javascript"></script>
		<script src="js/custom.js" type="text/javascript"></script>

		<script type="text/javascript" charset="utf-8">
			// ------ Full Screen Slide Show ------ //
			$(function(){
				$('#maximage').maximage({
					cycleOptions: {
						fx: 'fade',
						speed: 1000,
						timeout: 5000,
						prev: '#arrow_left',
						next: '#arrow_right',
						pause: 0,
						before: function(last,current){
							if(!$.browser.msie){
								// Start HTML5 video when you arrive
								if($(current).find('video').length > 0) $(current).find('video')[0].play();
							}
						},
						after: function(last,current){
							if(!$.browser.msie){
								// Pauses HTML5 video when you leave it
								if($(last).find('video').length > 0) $(last).find('video')[0].pause();
							}
						}
					},
					onFirstImageLoaded: function(){
						jQuery('#maximage').fadeIn('fast');
					}
				});
	
				// Helper function to Fill and Center the HTML5 Video
				jQuery('video,object').maximage('maxcover');
	
			});
		</script>
	
  </body>
</html>
